<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/wwwboard.html">WWWBoard</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/wwwboard">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">wwwboard.pl</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h1 class="h3 mb-0">wwwboard.pl</h1>
        </div>
        <div class="card-body">
            <p class="lead">WWWBoard Main Script (Perl) - Version 2.0 ALPHA 2.1</p>
            <p class="text-muted">
                This is the main WWWBoard script that handles threaded message posting, followup replies,
                message display, and board rendering. Created in 1995, this was one of the first web-based
                discussion forum systems.
            </p>
            <div class="alert alert-info" role="alert">
                <strong>Historical Note:</strong> This script pioneered the concept of threaded web forums
                and influenced many modern forum systems. For production use, consider modern alternatives
                like phpBB, Discourse, or NodeBB.
            </div>
        </div>
    </div>

    <!-- File Content -->
    <div class="card mb-4">
        <div class="card-header">
            <h2 class="h5 mb-0">Source Code</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded" style="overflow-x: auto; max-height: 600px;"><code><?php
$script_file = __DIR__ . '/wwwboard.pl';
if (file_exists($script_file)) {
    echo htmlspecialchars(file_get_contents($script_file));
} else {
    echo "Error: wwwboard.pl file not found.";
}
?></code></pre>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex gap-2 mb-4">
        <a href="/scripts/downloads/wwwboard/wwwboard.pl" download class="btn btn-primary">
            <i class="bi bi-download"></i> Download wwwboard.pl
        </a>
        <a href="/scripts/downloads/wwwboard" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
        <a href="/scripts/wwwboard.html" class="btn btn-outline-secondary">
            <i class="bi bi-info-circle"></i> Script Info
        </a>
        <a href="/scripts/demos/wwwboard" class="btn btn-outline-success">
            <i class="bi bi-play-circle"></i> View Demo
        </a>
    </div>

    <!-- Additional Information -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-header">
                    <h2 class="h5 mb-0">Script Details</h2>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-4">File Type:</dt>
                        <dd class="col-sm-8">Perl Script (.pl)</dd>

                        <dt class="col-sm-4">Language:</dt>
                        <dd class="col-sm-8">Perl 5.x or higher</dd>

                        <dt class="col-sm-4">Purpose:</dt>
                        <dd class="col-sm-8">Main forum script</dd>

                        <dt class="col-sm-4">Version:</dt>
                        <dd class="col-sm-8">2.0 ALPHA 2.1</dd>

                        <dt class="col-sm-4">Created:</dt>
                        <dd class="col-sm-8">October 21, 1995</dd>

                        <dt class="col-sm-4">Last Modified:</dt>
                        <dd class="col-sm-8">January 7, 2000</dd>

                        <dt class="col-sm-4">Permissions:</dt>
                        <dd class="col-sm-8"><code>chmod 755</code></dd>

                        <dt class="col-sm-4">License:</dt>
                        <dd class="col-sm-8">Artistic License</dd>
                    </dl>
                </div>
            </div>
        </div>

        <div class="col-md-6 mb-3">
            <div class="card h-100 border-primary">
                <div class="card-header bg-primary text-white">
                    <h2 class="h5 mb-0">Script Features</h2>
                </div>
                <div class="card-body">
                    <ul class="mb-3">
                        <li>Threaded message display</li>
                        <li>Post new messages and followups</li>
                        <li>Individual message pages</li>
                        <li>HTML-based message formatting</li>
                        <li>Email notification support</li>
                        <li>File locking for concurrent access</li>
                        <li>Input sanitization and validation</li>
                        <li>Configurable message limits</li>
                    </ul>
                    <p class="mb-0 text-muted small">
                        <strong>Dependencies:</strong> CGI.pm, CGI::Carp, Fcntl modules
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Installation and Configuration -->
    <div class="card mb-3">
        <div class="card-header">
            <h2 class="h5 mb-0">Installation Steps</h2>
        </div>
        <div class="card-body">
            <ol class="mb-0">
                <li>Upload wwwboard.pl to your cgi-bin directory</li>
                <li>Set permissions: <code>chmod 755 wwwboard.pl</code></li>
                <li>Create messages directory: <code>mkdir messages && chmod 777 messages</code></li>
                <li>Create data file: <code>touch data.txt && chmod 666 data.txt</code></li>
                <li>Create board file: <code>touch wwwboard.html && chmod 666 wwwboard.html</code></li>
                <li><strong>IMPORTANT:</strong> Edit configuration variables at the top of the script:
                    <ul class="mt-2">
                        <li><code>$basedir</code> - Base directory path</li>
                        <li><code>$baseurl</code> - Base URL for links</li>
                        <li><code>$cgi_url</code> - Script URL</li>
                        <li><code>$admin_password</code> - Admin password (CHANGE THIS!)</li>
                    </ul>
                </li>
                <li>Test by accessing: <code>/cgi-bin/wwwboard.pl</code></li>
            </ol>
        </div>
    </div>

    <!-- Related Files -->
    <div class="card">
        <div class="card-header">
            <h2 class="h5 mb-0">Related Files</h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Documentation:</h6>
                    <ul>
                        <li><a href="/scripts/downloads/wwwboard/README">README</a> - Installation guide</li>
                        <li><a href="/scripts/downloads/wwwboard/ADMIN_README">ADMIN_README</a> - Admin documentation</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>Scripts:</h6>
                    <ul>
                        <li><a href="/scripts/downloads/wwwboard/wwwadmin.pl">wwwadmin.pl</a> - Administration script</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
