<?php
$title = "wwwboard.pl - WWWBoard Main Script - Matt's Script Archive";
$description = "WWWBoard main Perl script (wwwboard.pl) v2.0 ALPHA 2.1. Threaded discussion forum script that handles message posting, followups, and board display.";
$keywords = "wwwboard.pl, wwwboard script, perl cgi, discussion forum, message board, threaded forum";
$canonical_url = "https://worldwidemart.com/scripts/downloads/wwwboard/wwwboard.pl";
?>
<!-- Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo htmlspecialchars($title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($description); ?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo $canonical_url; ?>">
<meta property="og:site_name" content="Matt's Script Archive">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary">
<meta name="twitter:title" content="<?php echo htmlspecialchars($title); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($description); ?>">

<!-- Schema.org Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "SoftwareSourceCode",
  "name": "wwwboard.pl",
  "description": "<?php echo htmlspecialchars($description); ?>",
  "url": "<?php echo $canonical_url; ?>",
  "programmingLanguage": "Perl",
  "codeRepository": "https://worldwidemart.com/scripts/",
  "runtimePlatform": "Unix/Linux",
  "applicationCategory": "WebApplication",
  "softwareVersion": "2.0 ALPHA 2.1",
  "dateCreated": "1995-10-21",
  "dateModified": "2000-01-07",
  "copyrightHolder": {
    "@type": "Organization",
    "name": "worldwidemart.com"
  },
  "license": "https://opensource.org/licenses/Artistic-2.0"
}
</script>
