<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/wwwboard.html">WWWBoard</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/wwwboard">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">wwwadmin.pl</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-danger text-white">
            <h1 class="h3 mb-0">wwwadmin.pl</h1>
        </div>
        <div class="card-body">
            <p class="lead">WWWBoard Administration Script (Perl)</p>
            <p class="text-muted">
                This is the administrative interface script for WWWBoard. It provides login authentication,
                message management, deletion capabilities, and board reset functionality.
            </p>
            <div class="alert alert-danger" role="alert">
                <strong>Important:</strong> You MUST change the default admin password before deploying this script!
            </div>
        </div>
    </div>

    <!-- File Content -->
    <div class="card mb-4">
        <div class="card-header">
            <h2 class="h5 mb-0">Source Code</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded" style="overflow-x: auto; max-height: 600px;"><code><?php
$script_file = __DIR__ . '/wwwadmin.pl';
if (file_exists($script_file)) {
    echo htmlspecialchars(file_get_contents($script_file));
} else {
    echo "Error: wwwadmin.pl file not found.";
}
?></code></pre>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex gap-2 mb-4">
        <a href="/scripts/downloads/wwwboard/wwwadmin.pl" download class="btn btn-danger">
            <i class="bi bi-download"></i> Download wwwadmin.pl
        </a>
        <a href="/scripts/downloads/wwwboard" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
        <a href="/scripts/wwwboard.html" class="btn btn-outline-secondary">
            <i class="bi bi-info-circle"></i> Script Info
        </a>
    </div>

    <!-- Additional Information -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-header">
                    <h2 class="h5 mb-0">Script Details</h2>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-4">File Type:</dt>
                        <dd class="col-sm-8">Perl Script (.pl)</dd>

                        <dt class="col-sm-4">Language:</dt>
                        <dd class="col-sm-8">Perl 5.x</dd>

                        <dt class="col-sm-4">Purpose:</dt>
                        <dd class="col-sm-8">Admin panel interface</dd>

                        <dt class="col-sm-4">Version:</dt>
                        <dd class="col-sm-8">2.0 ALPHA 2</dd>

                        <dt class="col-sm-4">Permissions:</dt>
                        <dd class="col-sm-8"><code>chmod 755</code></dd>
                    </dl>
                </div>
            </div>
        </div>

        <div class="col-md-6 mb-3">
            <div class="card h-100 border-danger">
                <div class="card-header bg-danger text-white">
                    <h2 class="h5 mb-0">Admin Features</h2>
                </div>
                <div class="card-body">
                    <ul class="mb-3">
                        <li>Password-protected login interface</li>
                        <li>View all posted messages</li>
                        <li>Delete individual messages</li>
                        <li>View board statistics</li>
                        <li>Reset entire board (danger zone)</li>
                    </ul>
                    <p class="mb-0 text-muted small">
                        <strong>Note:</strong> Default password is "changeme" - must be changed in the script!
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Installation Notes -->
    <div class="card">
        <div class="card-header">
            <h2 class="h5 mb-0">Installation Notes</h2>
        </div>
        <div class="card-body">
            <ol class="mb-0">
                <li>Upload wwwadmin.pl to your cgi-bin directory</li>
                <li>Set permissions: <code>chmod 755 wwwadmin.pl</code></li>
                <li><strong>IMPORTANT:</strong> Edit the file and change <code>$admin_password = 'changeme';</code></li>
                <li>Ensure the password matches the one in wwwboard.pl</li>
                <li>Access via: <code>/cgi-bin/wwwadmin.pl</code></li>
                <li>Consider adding .htaccess protection for extra security</li>
            </ol>
        </div>
    </div>
</div>
