<?php
$title = "wwwadmin.pl - WWWBoard Admin Script - Matt's Script Archive";
$description = "WWWBoard administration Perl script (wwwadmin.pl). Admin interface for managing messages, deleting posts, and resetting the discussion board.";
$keywords = "wwwadmin.pl, wwwboard admin, perl script, forum administration, message moderation";
$canonical_url = "https://worldwidemart.com/scripts/downloads/wwwboard/wwwadmin.pl";
?>
<!-- Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo htmlspecialchars($title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($description); ?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo $canonical_url; ?>">
<meta property="og:site_name" content="Matt's Script Archive">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary">
<meta name="twitter:title" content="<?php echo htmlspecialchars($title); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($description); ?>">

<!-- Schema.org Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "SoftwareSourceCode",
  "name": "wwwadmin.pl",
  "description": "<?php echo htmlspecialchars($description); ?>",
  "url": "<?php echo $canonical_url; ?>",
  "programmingLanguage": "Perl",
  "codeRepository": "https://worldwidemart.com/scripts/",
  "runtimePlatform": "Unix/Linux",
  "applicationCategory": "WebApplication",
  "isPartOf": {
    "@type": "SoftwareApplication",
    "name": "WWWBoard",
    "softwareVersion": "2.0 ALPHA 2"
  }
}
</script>
