#!/usr/bin/perl
##############################################################################
# WWWAdmin                       Version 2.0 ALPHA 2                         #
# Copyright 1996                 worldwidemart.com                           #
# Scripts Archive:               https://www.worldwidemart.com/scripts/          #
##############################################################################
# Administrative interface for WWWBoard                                      #
##############################################################################

use strict;
use warnings;
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);

# Configuration - MUST match wwwboard.pl settings
my $basedir     = '.';
my $meession    = "$basedir/wwwboard.html";
my $message_dir = "$basedir/messages";
my $data_file   = "$basedir/data.txt";

# Admin password - CHANGE THIS!
my $admin_password = 'changeme';

##############################################################################
# Main Script
##############################################################################

my $cgi = CGI->new;
my $action = $cgi->param('action') || 'login';
my $pass   = $cgi->param('password') || '';

if ($action eq 'login' || !verify_password($pass)) {
    show_login();
} elsif ($action eq 'admin') {
    show_admin();
} elsif ($action eq 'delete') {
    delete_messages();
} elsif ($action eq 'reset') {
    reset_board();
}

##############################################################################
# Subroutines
##############################################################################

sub verify_password {
    my ($pass) = @_;
    return $pass eq $admin_password;
}

sub show_login {
    print $cgi->header('text/html');
    print <<HTML;
<!DOCTYPE html>
<html>
<head>
    <title>WWWBoard Admin Login</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 400px; margin: 50px auto; padding: 20px; }
        .login-box { background: #f8f9fa; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { margin-top: 0; color: #333; }
        input[type="password"] { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 12px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class="login-box">
        <h1>WWWBoard Admin</h1>
        <form method="POST">
            <input type="hidden" name="action" value="admin">
            <label>Password:</label>
            <input type="password" name="password" required autofocus>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
HTML
}

sub show_admin {
    print $cgi->header('text/html');

    # Get list of messages
    my @messages;
    if (-d $message_dir) {
        opendir(my $dh, $message_dir);
        @messages = sort { $b <=> $a } grep { /^\d+\.html$/ } readdir($dh);
        closedir($dh);
    }

    print <<HTML;
<!DOCTYPE html>
<html>
<head>
    <title>WWWBoard Administration</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; }
        h1 { color: #333; }
        .stats { background: #e9ecef; padding: 15px; border-radius: 5px; margin: 20px 0; }
        .message-list { list-style: none; padding: 0; }
        .message-list li { padding: 10px; border-bottom: 1px solid #ddd; }
        .message-list li:hover { background: #f8f9fa; }
        .delete-btn { background: #dc3545; color: white; padding: 5px 10px; border: none; border-radius: 3px; cursor: pointer; margin-left: 10px; }
        .action-box { background: #fff3cd; padding: 15px; border-radius: 5px; margin: 20px 0; }
        .danger-btn { background: #dc3545; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; }
    </style>
</head>
<body>
    <h1>WWWBoard Administration</h1>

    <div class="stats">
        <strong>Statistics:</strong><br>
        Total Messages: @{[scalar @messages]}
    </div>

    <h2>Messages</h2>
    <form method="POST">
        <input type="hidden" name="action" value="delete">
        <input type="hidden" name="password" value="$pass">
        <ul class="message-list">
HTML

    foreach my $msg (@messages) {
        my $num = $msg;
        $num =~ s/\.html$//;
        print qq{<li><input type="checkbox" name="delete_$num"> Message #$num <a href="$message_dir/$msg" target="_blank">View</a></li>\n};
    }

    print <<HTML;
        </ul>
        <button type="submit" class="delete-btn">Delete Selected</button>
    </form>

    <div class="action-box">
        <h3>Danger Zone</h3>
        <form method="POST" onsubmit="return confirm('Are you sure? This cannot be undone!');">
            <input type="hidden" name="action" value="reset">
            <input type="hidden" name="password" value="$pass">
            <button type="submit" class="danger-btn">Reset Entire Board</button>
        </form>
    </div>

    <p><a href="$meession">Back to Board</a></p>
</body>
</html>
HTML
}

sub delete_messages {
    foreach my $key ($cgi->param) {
        if ($key =~ /^delete_(\d+)$/) {
            my $num = $1;
            unlink "$message_dir/$num.html" if -e "$message_dir/$num.html";
        }
    }
    show_admin();
}

sub reset_board {
    # Remove all messages
    if (-d $message_dir) {
        opendir(my $dh, $message_dir);
        foreach my $file (readdir($dh)) {
            next if $file =~ /^\./;
            unlink "$message_dir/$file";
        }
        closedir($dh);
    }

    # Reset counter
    open(my $fh, '>', $data_file);
    print $fh "0";
    close($fh);

    # Reset main board
    open($fh, '>', $meession);
    print $fh get_default_board();
    close($fh);

    show_admin();
}

sub get_default_board {
    return <<'TEMPLATE';
<!DOCTYPE html>
<html>
<head>
    <title>WWWBoard - Discussion Forum</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; }
    </style>
</head>
<body>
    <h1>WWWBoard</h1>
    <p><a href="wwwboard.pl?action=followup">Post New Message</a></p>
    <ul>
    <!-- MESSAGES -->
    </ul>
</body>
</html>
TEMPLATE
}

__END__
