<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/wwwboard.html">WWWBoard</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/wwwboard">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">README</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h1 class="h3 mb-0">README</h1>
        </div>
        <div class="card-body">
            <p class="lead">WWWBoard v2.0 ALPHA 2.1 - Documentation File</p>
            <p class="text-muted">
                This README file contains complete installation instructions, features, requirements,
                and important security notes for the WWWBoard threaded discussion forum script.
            </p>
        </div>
    </div>

    <!-- File Content -->
    <div class="card mb-4">
        <div class="card-header">
            <h2 class="h5 mb-0">File Contents</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded" style="overflow-x: auto;"><code><?php
$readme_file = __DIR__ . '/README';
if (file_exists($readme_file)) {
    echo htmlspecialchars(file_get_contents($readme_file));
} else {
    echo "Error: README file not found.";
}
?></code></pre>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex gap-2 mb-4">
        <a href="/scripts/downloads/wwwboard/README" download class="btn btn-primary">
            <i class="bi bi-download"></i> Download README
        </a>
        <a href="/scripts/downloads/wwwboard" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
        <a href="/scripts/wwwboard.html" class="btn btn-outline-secondary">
            <i class="bi bi-info-circle"></i> Script Info
        </a>
    </div>

    <!-- Additional Information -->
    <div class="card">
        <div class="card-header">
            <h2 class="h5 mb-0">About This File</h2>
        </div>
        <div class="card-body">
            <dl class="row mb-0">
                <dt class="col-sm-3">File Type:</dt>
                <dd class="col-sm-9">Documentation (Plain Text)</dd>

                <dt class="col-sm-3">Purpose:</dt>
                <dd class="col-sm-9">Installation and usage instructions for WWWBoard script</dd>

                <dt class="col-sm-3">Related Files:</dt>
                <dd class="col-sm-9">
                    <a href="/scripts/downloads/wwwboard/ADMIN_README">ADMIN_README</a> -
                    Administration documentation
                </dd>
            </dl>
        </div>
    </div>
</div>
