<?php
$title = "README - WWWBoard Script - Matt's Script Archive";
$description = "WWWBoard v2.0 ALPHA 2.1 documentation file. Complete installation instructions, features, and requirements for the threaded discussion forum script.";
$keywords = "wwwboard, readme, documentation, installation, perl script, discussion forum, message board";
$canonical_url = "https://worldwidemart.com/scripts/downloads/wwwboard/README";
?>
<!-- Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo htmlspecialchars($title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($description); ?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo $canonical_url; ?>">
<meta property="og:site_name" content="Matt's Script Archive">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary">
<meta name="twitter:title" content="<?php echo htmlspecialchars($title); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($description); ?>">

<!-- Schema.org Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "<?php echo htmlspecialchars($title); ?>",
  "description": "<?php echo htmlspecialchars($description); ?>",
  "url": "<?php echo $canonical_url; ?>",
  "articleSection": "Documentation",
  "keywords": "<?php echo $keywords; ?>",
  "about": {
    "@type": "SoftwareApplication",
    "name": "WWWBoard",
    "applicationCategory": "WebApplication",
    "operatingSystem": "Unix/Linux",
    "softwareVersion": "2.0 ALPHA 2.1"
  }
}
</script>
