<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/wwwboard.html">WWWBoard</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/wwwboard">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">ADMIN_README</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-danger text-white">
            <h1 class="h3 mb-0">ADMIN_README</h1>
        </div>
        <div class="card-body">
            <p class="lead">WWWBoard Administration Documentation</p>
            <p class="text-muted">
                This file contains important information about accessing and using the WWWBoard
                administration panel, including password management and moderation tips.
            </p>
            <div class="alert alert-warning" role="alert">
                <strong>Security Notice:</strong> Always change the default admin password immediately after installation!
            </div>
        </div>
    </div>

    <!-- File Content -->
    <div class="card mb-4">
        <div class="card-header">
            <h2 class="h5 mb-0">File Contents</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded" style="overflow-x: auto;"><code><?php
$readme_file = __DIR__ . '/ADMIN_README';
if (file_exists($readme_file)) {
    echo htmlspecialchars(file_get_contents($readme_file));
} else {
    echo "Error: ADMIN_README file not found.";
}
?></code></pre>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex gap-2 mb-4">
        <a href="/scripts/downloads/wwwboard/ADMIN_README" download class="btn btn-danger">
            <i class="bi bi-download"></i> Download ADMIN_README
        </a>
        <a href="/scripts/downloads/wwwboard" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
        <a href="/scripts/wwwboard.html" class="btn btn-outline-secondary">
            <i class="bi bi-info-circle"></i> Script Info
        </a>
    </div>

    <!-- Additional Information -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-header">
                    <h2 class="h5 mb-0">About This File</h2>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-5">File Type:</dt>
                        <dd class="col-sm-7">Documentation (Plain Text)</dd>

                        <dt class="col-sm-5">Purpose:</dt>
                        <dd class="col-sm-7">Admin panel instructions</dd>

                        <dt class="col-sm-5">Related Files:</dt>
                        <dd class="col-sm-7">
                            <a href="/scripts/downloads/wwwboard/wwwadmin.pl">wwwadmin.pl</a>
                        </dd>
                    </dl>
                </div>
            </div>
        </div>

        <div class="col-md-6 mb-3">
            <div class="card h-100 border-warning">
                <div class="card-header bg-warning">
                    <h2 class="h5 mb-0">Security Checklist</h2>
                </div>
                <div class="card-body">
                    <ul class="mb-0">
                        <li>Change default password immediately</li>
                        <li>Use strong password (letters, numbers, symbols)</li>
                        <li>Consider adding .htaccess protection</li>
                        <li>Regularly check for spam and inappropriate content</li>
                        <li>Back up message files periodically</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
