<?php
$title = "ADMIN_README - WWWBoard Script - Matt's Script Archive";
$description = "WWWBoard administration documentation. Learn how to access the admin panel, change passwords, and moderate your discussion forum.";
$keywords = "wwwboard, admin, administration, documentation, moderation, password, forum management";
$canonical_url = "https://worldwidemart.com/scripts/downloads/wwwboard/ADMIN_README";
?>
<!-- Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo htmlspecialchars($title); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($description); ?>">
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo $canonical_url; ?>">
<meta property="og:site_name" content="Matt's Script Archive">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary">
<meta name="twitter:title" content="<?php echo htmlspecialchars($title); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($description); ?>">

<!-- Schema.org Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "<?php echo htmlspecialchars($title); ?>",
  "description": "<?php echo htmlspecialchars($description); ?>",
  "url": "<?php echo $canonical_url; ?>",
  "articleSection": "Administration",
  "keywords": "<?php echo $keywords; ?>",
  "about": {
    "@type": "SoftwareApplication",
    "name": "WWWBoard Admin",
    "applicationCategory": "WebApplication",
    "operatingSystem": "Unix/Linux"
  }
}
</script>
