<div class="container my-4">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/textcounter.shtml">Text Counter</a></li>
            <li class="breadcrumb-item active" aria-current="page">Download</li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <h1 class="display-5 mb-3">Text Counter Script Download</h1>
            <p class="lead">Download the Text Counter CGI script to count page visits and display results in text format.</p>
            <p class="text-muted">Version 1.0 | Perl CGI Script</p>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h3 class="h6 card-title">Quick Links</h3>
                    <ul class="list-unstyled small mb-0">
                        <li class="mb-1"><a href="/scripts/textcounter.shtml">Script Overview</a></li>
                        <li class="mb-1"><a href="/scripts/readme/">Documentation</a></li>
                        <li class="mb-1"><a href="/scripts/examples/textcounter.shtml">Examples</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Download Section -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h2 class="h5 mb-0">Download Options</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">TAR.GZ Archive</h3>
                                <p class="text-muted">Unix/Linux compressed archive</p>
                                <a href="/scripts/downloads/textcounter.tar.gz" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .tar.gz
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">ZIP Archive</h3>
                                <p class="text-muted">Windows/Mac compressed archive</p>
                                <a href="/scripts/downloads/textcounter.zip" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .zip
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Files Included -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Files Included</h2>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Filename</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><code>README</code></td>
                                <td>Installation instructions and documentation</td>
                            </tr>
                            <tr>
                                <td><code>textcounter.pl</code></td>
                                <td>Text Counter CGI script</td>
                            </tr>
                            <tr>
                                <td><code>count.txt</code></td>
                                <td>Count database file</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Installation Notes -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h2 class="h5 mb-0">Installation Notes</h2>
            </div>
            <div class="card-body">
                <ol>
                    <li>Download either the .tar.gz or .zip archive</li>
                    <li>Extract the archive contents to your server</li>
                    <li>Read the README file for detailed installation instructions</li>
                    <li>Configure the script according to your requirements</li>
                    <li>Set appropriate file permissions (chmod 755 for .pl files, 666 for count.txt)</li>
                    <li>Test the script to ensure proper functionality</li>
                </ol>

                <div class="alert alert-info mt-3" role="alert">
                    <strong>Features:</strong> Simple text-based counter, no graphics required, lightweight and fast.
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation -->
    <div class="mt-4">
        <a href="/scripts/textcounter.shtml" class="btn btn-outline-primary">
            <i class="bi bi-arrow-left"></i> Back to Text Counter Overview
        </a>
        <a href="/scripts/" class="btn btn-outline-secondary">
            Script Archive Home
        </a>
    </div>

</div><!-- /.container -->
