<div class="container my-4">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/ssi_image.shtml">SSI Random Image</a></li>
            <li class="breadcrumb-item active" aria-current="page">Download</li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <h1 class="display-5 mb-3">SSI Random Image Script Download</h1>
            <p class="lead">Download the SSI Random Image CGI script to display rotating images using Server Side Includes.</p>
            <p class="text-muted">Version 1.0 | Perl CGI Script</p>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h3 class="h6 card-title">Quick Links</h3>
                    <ul class="list-unstyled small mb-0">
                        <li class="mb-1"><a href="/scripts/ssi_image.shtml">Script Overview</a></li>
                        <li class="mb-1"><a href="/scripts/readme/">Documentation</a></li>
                        <li class="mb-1"><a href="/scripts/examples/ssi_image.shtml">Examples</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Download Section -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h2 class="h5 mb-0">Download Options</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">TAR.GZ Archive</h3>
                                <p class="text-muted">Unix/Linux compressed archive</p>
                                <a href="/scripts/downloads/ssi_image.tar.gz" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .tar.gz
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">ZIP Archive</h3>
                                <p class="text-muted">Windows/Mac compressed archive</p>
                                <a href="/scripts/downloads/ssi_image.zip" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .zip
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Files Included -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Files Included</h2>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Filename</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><code>README</code></td>
                                <td>Installation instructions and documentation</td>
                            </tr>
                            <tr>
                                <td><code>ssi_rand_image.pl</code></td>
                                <td>SSI Random Image CGI script</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Installation Notes -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h2 class="h5 mb-0">Installation Notes</h2>
            </div>
            <div class="card-body">
                <ol>
                    <li>Download either the .tar.gz or .zip archive</li>
                    <li>Extract the archive contents to your server</li>
                    <li>Read the README file for detailed installation instructions</li>
                    <li>Configure the script to point to your image directory</li>
                    <li>Set appropriate file permissions (chmod 755 for .pl files)</li>
                    <li>Enable Server Side Includes on your web server if not already enabled</li>
                    <li>Use SSI tags in your HTML pages to include the script</li>
                    <li>Test the script to ensure proper functionality</li>
                </ol>

                <div class="alert alert-warning mt-3" role="alert">
                    <strong>Requirement:</strong> This script requires Server Side Includes (SSI) to be enabled on your web server.
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation -->
    <div class="mt-4">
        <a href="/scripts/ssi_image.shtml" class="btn btn-outline-primary">
            <i class="bi bi-arrow-left"></i> Back to SSI Random Image Overview
        </a>
        <a href="/scripts/" class="btn btn-outline-secondary">
            Script Archive Home
        </a>
    </div>

</div><!-- /.container -->
