<div class="container my-4">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/rand_text.shtml">Random Text</a></li>
            <li class="breadcrumb-item active" aria-current="page">Download</li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <h1 class="display-5 mb-3">Random Text Script Download</h1>
            <p class="lead">Download the Random Text script to display random quotes, tips, or text snippets on your website using Server Side Includes.</p>
            <p class="text-muted">Version 1.0 | Perl CGI Script</p>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h3 class="h6 card-title">Quick Links</h3>
                    <ul class="list-unstyled small mb-0">
                        <li class="mb-1"><a href="/scripts/rand_text.shtml">Script Overview</a></li>
                        <li class="mb-1"><a href="/scripts/readme/rand_text.shtml">Documentation</a></li>
                        <li class="mb-1"><a href="/scripts/examples/rand_text.shtml">Examples</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Download Section -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h2 class="h5 mb-0">Download Options</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">TAR.GZ Archive</h3>
                                <p class="text-muted">Unix/Linux compressed archive</p>
                                <a href="/scripts/downloads/rand_text.tar.gz" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .tar.gz
                                </a>
                                <p class="small text-muted mt-2">~4.2 KB</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="card h-100 border-primary">
                            <div class="card-body text-center">
                                <h3 class="h5 card-title">ZIP Archive</h3>
                                <p class="text-muted">Windows/Mac compressed archive</p>
                                <a href="/scripts/downloads/rand_text.zip" class="btn btn-primary btn-lg">
                                    <i class="bi bi-download"></i> Download .zip
                                </a>
                                <p class="small text-muted mt-2">~4.8 KB</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Files Included -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Files Included</h2>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Filename</th>
                                <th>Description</th>
                                <th>View</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><code>README</code></td>
                                <td>Installation instructions and documentation</td>
                                <td><a href="README" class="btn btn-sm btn-outline-primary">View</a></td>
                            </tr>
                            <tr>
                                <td><code>rand_text.pl</code></td>
                                <td>Main Random Text CGI script</td>
                                <td><a href="rand_text.pl" class="btn btn-sm btn-outline-primary">View</a></td>
                            </tr>
                            <tr>
                                <td><code>quotes.txt</code></td>
                                <td>Sample text file with example quotes</td>
                                <td><a href="quotes.txt" class="btn btn-sm btn-outline-primary">View</a></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="alert alert-info mt-3">
                    <i class="bi bi-lightbulb"></i> <strong>Tip:</strong> The quotes.txt file is a sample. Create your own text files with custom quotes, tips, or snippets for your website.
                </div>
            </div>
        </div>
    </section>

    <!-- Installation Notes -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h2 class="h5 mb-0">Installation Notes</h2>
            </div>
            <div class="card-body">
                <h5 class="card-title">Quick Start Guide</h5>
                <ol>
                    <li>Download either the .tar.gz or .zip archive</li>
                    <li>Extract the archive contents to your server</li>
                    <li>Upload <code>rand_text.pl</code> to your cgi-bin directory</li>
                    <li>Upload <code>quotes.txt</code> to a web-accessible directory</li>
                    <li>Set permissions: <code>chmod 755 rand_text.pl</code></li>
                    <li>Edit <code>rand_text.pl</code> to set the path to your text file</li>
                    <li>Add to your .shtml pages: <code>&lt;!--#exec cgi="/cgi-bin/rand_text.pl"--&gt;</code></li>
                    <li>Test and enjoy random quotes on your site!</li>
                </ol>

                <h5 class="mt-4">Configuration</h5>
                <p>Edit the following variables in <code>rand_text.pl</code>:</p>
                <pre><code class="language-perl">$textfile = "/path/to/quotes.txt";  # Path to your text file
$separator = "%%";                   # Separator between quotes</code></pre>

                <h5 class="mt-4">Creating Your Text File</h5>
                <p>Format your text file with quotes separated by <code>%%</code> on its own line:</p>
                <pre><code>The only way to do great work is to love what you do. - Steve Jobs
%%
Innovation distinguishes between a leader and a follower. - Steve Jobs
%%
Your time is limited, don't waste it living someone else's life. - Steve Jobs
%%
Stay hungry, stay foolish. - Steve Jobs</code></pre>

                <div class="alert alert-warning mt-3" role="alert">
                    <strong>Requirements:</strong> Perl 5+ and web server with CGI and SSI support enabled.
                </div>
            </div>
        </div>
    </section>

    <!-- Usage Examples -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Usage Examples</h2>
            </div>
            <div class="card-body">
                <h5>Basic Usage (SSI)</h5>
                <pre><code class="language-html">&lt;!--#exec cgi="/cgi-bin/rand_text.pl"--&gt;</code></pre>

                <h5 class="mt-4">With Custom Styling</h5>
                <pre><code class="language-html">&lt;div class="quote-of-the-day"&gt;
    &lt;!--#exec cgi="/cgi-bin/rand_text.pl"--&gt;
&lt;/div&gt;

&lt;style&gt;
.quote-of-the-day {
    font-style: italic;
    padding: 15px;
    border-left: 4px solid #007bff;
    background: #f8f9fa;
    margin: 20px 0;
}
&lt;/style&gt;</code></pre>

                <h5 class="mt-4">Multiple Text Files</h5>
                <p>Pass the filename as a query parameter:</p>
                <pre><code class="language-html">&lt;!-- Display random quote --&gt;
&lt;!--#exec cgi="/cgi-bin/rand_text.pl?file=quotes.txt"--&gt;

&lt;!-- Display random tip --&gt;
&lt;!--#exec cgi="/cgi-bin/rand_text.pl?file=tips.txt"--&gt;

&lt;!-- Display random testimonial --&gt;
&lt;!--#exec cgi="/cgi-bin/rand_text.pl?file=testimonials.txt"--&gt;</code></pre>

                <h5 class="mt-4">As JavaScript Include (Alternative)</h5>
                <pre><code class="language-html">&lt;script src="/cgi-bin/rand_text.pl"&gt;&lt;/script&gt;</code></pre>
                <p class="small text-muted">Requires modifying the script to output JavaScript instead of HTML.</p>
            </div>
        </div>
    </section>

    <!-- Text File Ideas -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h2 class="h5 mb-0">Creative Uses</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Content Ideas</h5>
                        <ul>
                            <li><strong>Quotes:</strong> Inspirational, motivational, or topic-specific quotes</li>
                            <li><strong>Tips:</strong> Daily tips, tricks, or advice</li>
                            <li><strong>Testimonials:</strong> Customer reviews or feedback</li>
                            <li><strong>Fun Facts:</strong> Interesting trivia or did-you-know items</li>
                            <li><strong>Product Highlights:</strong> Featured products or services</li>
                            <li><strong>Jokes:</strong> Daily humor or dad jokes</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h5>Display Locations</h5>
                        <ul>
                            <li>Website header or footer</li>
                            <li>Sidebar widgets</li>
                            <li>Homepage feature section</li>
                            <li>Email signatures (static export)</li>
                            <li>Loading screens</li>
                            <li>404 error pages</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Troubleshooting -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Troubleshooting</h2>
            </div>
            <div class="card-body">
                <div class="accordion" id="troubleshootAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#trouble1">
                                Script shows "Internal Server Error"
                            </button>
                        </h2>
                        <div id="trouble1" class="accordion-collapse collapse show" data-bs-parent="#troubleshootAccordion">
                            <div class="accordion-body">
                                <ul>
                                    <li>Check file permissions (should be 755)</li>
                                    <li>Verify the Perl path in shebang line</li>
                                    <li>Ensure text file path is correct</li>
                                    <li>Check server error logs for details</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trouble2">
                                Shows same text every time
                            </button>
                        </h2>
                        <div id="trouble2" class="accordion-collapse collapse" data-bs-parent="#troubleshootAccordion">
                            <div class="accordion-body">
                                <ul>
                                    <li>Browser may be caching the SSI output</li>
                                    <li>Check that rand() function is working</li>
                                    <li>Verify separator (default %%) is correct</li>
                                    <li>Ensure text file has multiple entries</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trouble3">
                                SSI include not working
                            </button>
                        </h2>
                        <div id="trouble3" class="accordion-collapse collapse" data-bs-parent="#troubleshootAccordion">
                            <div class="accordion-body">
                                <ul>
                                    <li>Ensure your file has .shtml extension</li>
                                    <li>Check that SSI is enabled on your server</li>
                                    <li>Verify CGI execution is allowed via SSI</li>
                                    <li>Contact hosting support if needed</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Downloads -->
    <section class="mb-5">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Related Downloads</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <h6><a href="/scripts/downloads/rand_link/">Random Link</a></h6>
                        <p class="small text-muted">Display random links or banners on your site.</p>
                    </div>
                    <div class="col-md-4 mb-3">
                        <h6><a href="/scripts/downloads/rand_image/">Random Image</a></h6>
                        <p class="small text-muted">Show random images or graphics dynamically.</p>
                    </div>
                    <div class="col-md-4 mb-3">
                        <h6><a href="/scripts/downloads/textclock/">TextClock</a></h6>
                        <p class="small text-muted">Display current date and time via SSI.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation -->
    <div class="mt-4">
        <a href="/scripts/rand_text.shtml" class="btn btn-outline-primary">
            <i class="bi bi-arrow-left"></i> Back to Random Text Overview
        </a>
        <a href="/scripts/" class="btn btn-outline-secondary">
            Script Archive Home
        </a>
    </div>

</div><!-- /.container -->
