<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/formmail.html">FormMail</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/formmail/">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">README</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h1 class="h3 mb-0">README - FormMail Documentation</h1>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <p class="mb-2"><strong>File:</strong> README</p>
                    <p class="mb-2"><strong>Script:</strong> FormMail v1.6</p>
                    <p class="mb-2"><strong>Type:</strong> Documentation</p>
                    <p class="mb-0"><strong>Description:</strong> Installation guide, security warnings, and configuration instructions</p>
                </div>
                <div class="col-md-4 text-md-end">
                    <a href="/scripts/downloads/formmail/README" download class="btn btn-success mb-2">
                        <i class="bi bi-download"></i> Download README
                    </a>
                    <a href="/scripts/downloads/formmail/" class="btn btn-outline-primary mb-2">
                        <i class="bi bi-arrow-left"></i> Back to Downloads
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Warning Alert -->
    <div class="alert alert-danger" role="alert">
        <h4 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> Security Warning</h4>
        <p class="mb-0">This script is provided for <strong>HISTORICAL and EDUCATIONAL purposes only</strong>. The original FormMail had serious security vulnerabilities. For production websites, use modern alternatives like NMS FormMail, Tectite FormMail, or PHPMailer.</p>
    </div>

    <!-- File Content -->
    <div class="card">
        <div class="card-header">
            <h2 class="h5 mb-0">File Contents</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded"><code>##############################################################################
#                             FormMail v1.6                                  #
#                      Form to Email Gateway Script                          #
#                                                                            #
#                         Scripts Archive                                    #
#                    https://worldwidemart.com/scripts/                      #
##############################################################################

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                         SECURITY WARNING                                  !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                                           !
! This script is provided for HISTORICAL and EDUCATIONAL purposes only.     !
!                                                                           !
! The original FormMail had serious security vulnerabilities that were      !
! exploited by spammers for decades. This version includes basic fixes,     !
! but for production websites you should use modern alternatives:           !
!                                                                           !
! RECOMMENDED ALTERNATIVES:                                                 !
! - NMS FormMail: https://nms-cgi.sourceforge.net/                         !
! - Tectite FormMail: https://www.tectite.com/formmailpage.php             !
! - PHPMailer: https://github.com/PHPMailer/PHPMailer                      !
! - Formspree: https://formspree.io/                                       !
! - Netlify Forms: https://www.netlify.com/products/forms/                 !
!                                                                           !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

DESCRIPTION
-----------
FormMail is a generic WWW form to email gateway that parses the results of
any HTML form and sends them to specified email addresses.

FEATURES
--------
* Processes any HTML form and emails results
* Required field validation
* Email address validation
* Redirect after submission
* Customizable success/error pages
* Environment variable reporting
* Referer validation

REQUIREMENTS
------------
* Unix-based web server with CGI support
* Perl 5.x or higher
* sendmail or compatible mail transfer agent
* CGI.pm module

PACKAGE CONTENTS
----------------
FormMail.pl     - Main FormMail script
README          - This documentation file

INSTALLATION
------------
1. Upload FormMail.pl to your cgi-bin directory
2. Set permissions: chmod 755 FormMail.pl
3. Edit configuration variables:
   - @referers: List of domains allowed to use the form
   - @recipients: (Optional) List of allowed recipient addresses
   - $mailprog: Path to sendmail
4. Create your HTML form (see examples below)

CONFIGURATION
-------------
Edit these variables at the top of FormMail.pl:

@referers       - Domains allowed to use this script
@recipients     - Allowed email recipients (leave empty to allow form-specified)
$mailprog       - Path to sendmail (usually /usr/sbin/sendmail)

FORM FIELDS
-----------
Hidden fields you can use in your HTML form:

recipient       - (Required) Email address to send results to
subject         - Subject line of the email
redirect        - URL to redirect to after submission
required        - Comma-separated list of required fields
env_report      - Environment variables to include (REMOTE_HOST, etc.)
print_config    - Order of fields to print in email

EXAMPLE FORM
------------
&lt;form action="/cgi-bin/FormMail.pl" method="POST"&gt;
    &lt;input type="hidden" name="recipient" value="webmaster@yourdomain.com"&gt;
    &lt;input type="hidden" name="subject" value="Contact Form"&gt;
    &lt;input type="hidden" name="required" value="name,email,message"&gt;
    &lt;input type="hidden" name="redirect" value="https://yourdomain.com/thanks.html"&gt;

    &lt;label&gt;Name: &lt;input type="text" name="name"&gt;&lt;/label&gt;&lt;br&gt;
    &lt;label&gt;Email: &lt;input type="email" name="email"&gt;&lt;/label&gt;&lt;br&gt;
    &lt;label&gt;Message:&lt;br&gt;
    &lt;textarea name="message" rows="5" cols="40"&gt;&lt;/textarea&gt;&lt;/label&gt;&lt;br&gt;
    &lt;input type="submit" value="Send"&gt;
&lt;/form&gt;

SECURITY NOTES
--------------
1. ALWAYS set @referers to your domain(s)
2. Consider using @recipients to whitelist allowed addresses
3. Validate all user input
4. Keep Perl and modules updated
5. Monitor for unusual activity
6. Consider rate limiting

TROUBLESHOOTING
---------------
Problem: "Internal Server Error"
Solution: Check script permissions (755), verify Perl path, check error log

Problem: Email not received
Solution: Check $mailprog path, verify sendmail is working, check spam folder

Problem: "Invalid Referer" error
Solution: Add your domain to @referers configuration

HISTORICAL NOTES
----------------
FormMail was created in 1995 and became one of the most widely used CGI
scripts on the web. Unfortunately, it also became one of the most exploited
scripts due to email header injection vulnerabilities that allowed spammers
to use it as an open relay.

Key dates:
- 1995: FormMail created
- 1997: Version 1.6 released
- 2001: CVE-2001-0357 disclosed (email injection)
- 2002: FormMail listed as #3 attack vector (SecurityFocus)
- 2002: NMS project creates secure replacements

LICENSE
-------
Artistic License

##############################################################################
</code></pre>
        </div>
    </div>

    <!-- Actions -->
    <div class="mt-4 text-center">
        <a href="/scripts/downloads/formmail/README" download class="btn btn-success btn-lg">
            <i class="bi bi-download"></i> Download README
        </a>
        <a href="/scripts/downloads/formmail/FormMail.pl" class="btn btn-outline-primary btn-lg">
            <i class="bi bi-file-code"></i> View FormMail.pl
        </a>
        <a href="/scripts/downloads/formmail/" class="btn btn-outline-secondary btn-lg">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
    </div>
</div>
