<div class="container my-5">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/formmail.html">FormMail</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/formmail/">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">FormMail.pl</li>
        </ol>
    </nav>

    <!-- Page Header -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h1 class="h3 mb-0">FormMail.pl - Script Source Code</h1>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <p class="mb-2"><strong>File:</strong> FormMail.pl</p>
                    <p class="mb-2"><strong>Version:</strong> 1.6</p>
                    <p class="mb-2"><strong>Language:</strong> Perl 5.x</p>
                    <p class="mb-2"><strong>Size:</strong> ~305 lines</p>
                    <p class="mb-0"><strong>Description:</strong> Form to email gateway CGI script with security features</p>
                </div>
                <div class="col-md-4 text-md-end">
                    <a href="/scripts/downloads/formmail/FormMail.pl" download class="btn btn-success mb-2">
                        <i class="bi bi-download"></i> Download Script
                    </a>
                    <a href="/scripts/downloads/formmail/" class="btn btn-outline-primary mb-2">
                        <i class="bi bi-arrow-left"></i> Back to Downloads
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Warning Alert -->
    <div class="alert alert-danger" role="alert">
        <h4 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> Security Warning</h4>
        <p class="mb-0">This is a <strong>HISTORICAL script for educational purposes</strong>. DO NOT USE IN PRODUCTION. Use modern alternatives like NMS FormMail, Tectite FormMail, or PHP-based form handlers with proper validation and security.</p>
    </div>

    <!-- Installation Instructions -->
    <div class="card mb-4">
        <div class="card-header">
            <h2 class="h5 mb-0">Quick Installation</h2>
        </div>
        <div class="card-body">
            <ol>
                <li>Upload FormMail.pl to your <code>cgi-bin</code> directory</li>
                <li>Set permissions: <code>chmod 755 FormMail.pl</code></li>
                <li>Edit configuration variables (lines 24-29):
                    <ul>
                        <li><code>@referers</code> - Add your domain(s)</li>
                        <li><code>@recipients</code> - Optional whitelist of allowed email addresses</li>
                        <li><code>$mailprog</code> - Path to sendmail (usually <code>/usr/sbin/sendmail</code>)</li>
                    </ul>
                </li>
                <li>Create your HTML form pointing to the script</li>
            </ol>
            <div class="alert alert-warning mt-3 mb-0">
                <strong>Important:</strong> Always configure <code>@referers</code> to prevent abuse. See README for complete documentation.
            </div>
        </div>
    </div>

    <!-- File Content -->
    <div class="card">
        <div class="card-header">
            <h2 class="h5 mb-0">Source Code</h2>
        </div>
        <div class="card-body">
            <pre class="bg-light p-3 rounded" style="max-height: 600px; overflow-y: auto;"><code>#!/usr/bin/perl
##############################################################################
# FormMail                       Version 1.6                                 #
# Copyright 1995-1997            worldwidemart.com                           #
# Created 06/09/95               Last Modified 05/02/97                      #
# Scripts Archive:               https://www.worldwidemart.com/scripts/          #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# This script is distributed under the Artistic License.                     #
# You may freely use and modify it, keeping this copyright notice intact.    #
##############################################################################
# SECURITY WARNING                                                           #
# This is a HISTORICAL script preserved for educational purposes.            #
# DO NOT USE IN PRODUCTION - use modern alternatives like NMS FormMail,      #
# Tectite FormMail, or PHP-based form handlers.                              #
##############################################################################

use strict;
use warnings;
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);

# Configuration - MUST be set before use
my @referers = ('yourdomain.com', 'www.yourdomain.com');
my @recipients = ();  # Leave empty to use form recipient field
my @valid_ENV = ('REMOTE_HOST', 'REMOTE_ADDR', 'HTTP_USER_AGENT');

# Mail program configuration
my $mailprog = '/usr/sbin/sendmail -t -oi';

##############################################################################
# Main Script
##############################################################################

my $cgi = CGI-&gt;new;

# Check referer
check_referer();

# Get form data
my %form = $cgi-&gt;Vars;

# Validate required fields
my @required = split(/,/, $form{'required'} || '');
my @missing;
foreach my $field (@required) {
    $field =~ s/^\s+|\s+$//g;
    if (!$form{$field} || $form{$field} =~ /^\s*$/) {
        push @missing, $field;
    }
}

if (@missing) {
    error_page("Missing Required Fields", \@missing);
    exit;
}

# Validate email if provided
if ($form{'email'} &amp;&amp; $form{'email'} !~ /^[\w\.\-]+\@[\w\.\-]+\.\w+$/) {
    error_page("Invalid Email Address", ["email"]);
    exit;
}

# Get recipient
my $recipient = $form{'recipient'} || '';

# Validate recipient against allowed list
if (@recipients &amp;&amp; !grep { $_ eq $recipient } @recipients) {
    error_page("Invalid Recipient", []);
    exit;
}

# Security: Check for header injection
if ($recipient =~ /[\r\n]/ || ($form{'email'} &amp;&amp; $form{'email'} =~ /[\r\n]/)) {
    error_page("Invalid Characters Detected", []);
    exit;
}

# Build and send email
send_mail(\%form, $recipient);

# Show success page or redirect
if ($form{'redirect'}) {
    print $cgi-&gt;redirect($form{'redirect'});
} else {
    success_page(\%form);
}

##############################################################################
# Subroutines
##############################################################################

sub check_referer {
    my $referer = $ENV{'HTTP_REFERER'} || '';

    return if !@referers;  # No referer check if list is empty

    foreach my $ref (@referers) {
        return if $referer =~ /https?:\/\/([^\/]*\.)?\Q$ref\E/i;
    }

    error_page("Invalid Referer", []);
    exit;
}

sub send_mail {
    my ($form, $to) = @_;

    my $from = $form-&gt;{'email'} || 'noreply@' . ($ENV{'SERVER_NAME'} || 'localhost');
    my $subject = $form-&gt;{'subject'} || 'Form Submission';
    my $realname = $form-&gt;{'realname'} || '';

    # Build message body
    my $body = "The following information was submitted:\n";
    $body .= "=" x 50 . "\n\n";

    # Sort fields (put important ones first)
    my @order = defined $form-&gt;{'print_config'}
        ? split(/,/, $form-&gt;{'print_config'})
        : sort keys %$form;

    # Fields to skip in output
    my %skip = map { $_ =&gt; 1 } qw(
        recipient subject redirect required print_config
        env_report print_blank_fields
    );

    foreach my $field (@order) {
        next if $skip{$field};
        next if !$form-&gt;{'print_blank_fields'} &amp;&amp; (!$form-&gt;{$field} || $form-&gt;{$field} =~ /^\s*$/);

        my $value = $form-&gt;{$field} || '';
        $value =~ s/\r\n/\n/g;
        $body .= "$field: $value\n\n";
    }

    # Add environment variables if requested
    if ($form-&gt;{'env_report'}) {
        $body .= "-" x 50 . "\n";
        $body .= "Environment Information:\n\n";
        foreach my $var (split(/,/, $form-&gt;{'env_report'})) {
            $var =~ s/^\s+|\s+$//g;
            next unless grep { $_ eq $var } @valid_ENV;
            $body .= "$var: " . ($ENV{$var} || 'Not Available') . "\n";
        }
    }

    # Send email
    open(my $mail, '|-', $mailprog) or do {
        error_page("Mail Error", ["Could not send email"]);
        exit;
    };

    print $mail "To: $to\n";
    print $mail "From: $from\n";
    print $mail "Reply-To: $from\n";
    print $mail "Subject: $subject\n";
    print $mail "X-Mailer: FormMail (worldwidemart.com)\n";
    print $mail "\n";
    print $mail $body;

    close($mail);
}

sub success_page {
    my ($form) = @_;

    print $cgi-&gt;header('text/html');
    print &lt;&lt;HTML;
&lt;!DOCTYPE html&gt;
&lt;html&gt;
&lt;head&gt;
    &lt;title&gt;Form Submitted Successfully&lt;/title&gt;
    &lt;style&gt;
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #28a745; }
        .back { margin-top: 20px; }
        a { color: #007bff; }
    &lt;/style&gt;
&lt;/head&gt;
&lt;body&gt;
    &lt;div class="container"&gt;
        &lt;h1&gt;Thank You!&lt;/h1&gt;
        &lt;p&gt;Your form has been submitted successfully.&lt;/p&gt;
        &lt;p&gt;Below is what was submitted:&lt;/p&gt;
        &lt;hr&gt;
HTML

    foreach my $key (sort keys %$form) {
        next if $key =~ /^(recipient|subject|redirect|required|print_config|env_report)$/;
        my $value = $form-&gt;{$key} || '';
        $value = $cgi-&gt;escapeHTML($value);
        print "&lt;p&gt;&lt;strong&gt;$key:&lt;/strong&gt; $value&lt;/p&gt;\n";
    }

    print &lt;&lt;HTML;
        &lt;div class="back"&gt;
            &lt;a href="javascript:history.back()"&gt;&amp;larr; Go Back&lt;/a&gt;
        &lt;/div&gt;
    &lt;/div&gt;
&lt;/body&gt;
&lt;/html&gt;
HTML
}

sub error_page {
    my ($title, $fields) = @_;

    print $cgi-&gt;header('text/html');
    print &lt;&lt;HTML;
&lt;!DOCTYPE html&gt;
&lt;html&gt;
&lt;head&gt;
    &lt;title&gt;Error: $title&lt;/title&gt;
    &lt;style&gt;
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #dc3545; }
        .error-list { background: #fff3cd; padding: 15px; border-radius: 4px; }
        a { color: #007bff; }
    &lt;/style&gt;
&lt;/head&gt;
&lt;body&gt;
    &lt;div class="container"&gt;
        &lt;h1&gt;Error: $title&lt;/h1&gt;
HTML

    if (@$fields) {
        print "&lt;div class='error-list'&gt;&lt;p&gt;The following fields had problems:&lt;/p&gt;&lt;ul&gt;\n";
        foreach my $field (@$fields) {
            print "&lt;li&gt;" . $cgi-&gt;escapeHTML($field) . "&lt;/li&gt;\n";
        }
        print "&lt;/ul&gt;&lt;/div&gt;\n";
    }

    print &lt;&lt;HTML;
        &lt;p&gt;&lt;a href="javascript:history.back()"&gt;&amp;larr; Go Back and Try Again&lt;/a&gt;&lt;/p&gt;
    &lt;/div&gt;
&lt;/body&gt;
&lt;/html&gt;
HTML
}

__END__

=head1 NAME

FormMail.pl - Form to Email Gateway

=head1 SYNOPSIS

Create an HTML form with action pointing to this script:

  &lt;form action="/cgi-bin/FormMail.pl" method="POST"&gt;
    &lt;input type="hidden" name="recipient" value="you@example.com"&gt;
    &lt;input type="hidden" name="subject" value="Contact Form"&gt;
    ...
  &lt;/form&gt;

=head1 SECURITY WARNING

This script is provided for EDUCATIONAL PURPOSES ONLY.
For production use, please use modern alternatives:

- NMS FormMail: https://nms-cgi.sourceforge.net/
- Tectite FormMail: https://www.tectite.com/
- PHP form handlers with proper validation

=head1 HIDDEN FORM FIELDS

=over 4

=item recipient

Email address to send form data to (required)

=item subject

Subject line of email

=item redirect

URL to redirect to after successful submission

=item required

Comma-separated list of required field names

=item env_report

Comma-separated list of environment variables to include

=item print_config

Comma-separated list of fields to print (in order)

=back

=head1 LICENSE

Artistic License

=cut
</code></pre>
        </div>
    </div>

    <!-- Features List -->
    <div class="card mt-4">
        <div class="card-header">
            <h2 class="h5 mb-0">Key Features</h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <ul>
                        <li>Processes any HTML form</li>
                        <li>Required field validation</li>
                        <li>Email address validation</li>
                        <li>Referer domain validation</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul>
                        <li>Header injection protection</li>
                        <li>Customizable success/error pages</li>
                        <li>Environment variable reporting</li>
                        <li>Flexible field ordering</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Actions -->
    <div class="mt-4 text-center">
        <a href="/scripts/downloads/formmail/FormMail.pl" download class="btn btn-success btn-lg">
            <i class="bi bi-download"></i> Download FormMail.pl
        </a>
        <a href="/scripts/downloads/formmail/README" class="btn btn-outline-primary btn-lg">
            <i class="bi bi-file-text"></i> View README
        </a>
        <a href="/scripts/downloads/formmail/" class="btn btn-outline-secondary btn-lg">
            <i class="bi bi-arrow-left"></i> Back to Downloads
        </a>
    </div>
</div>
