<div class="container my-4">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/counter.shtml">Counter</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/counter/">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">counter.pl</li>
        </ol>
    </nav>

    <!-- File Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <h1 class="display-5 mb-3">counter.pl - Counter Script Source Code</h1>
            <p class="lead">Complete Perl source code for the Counter v1.1.1 graphical hit counter CGI script</p>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <strong>File Information</strong>
                </div>
                <div class="card-body">
                    <p class="mb-2 small"><strong>Filename:</strong> counter.pl</p>
                    <p class="mb-2 small"><strong>Type:</strong> Perl CGI Script</p>
                    <p class="mb-2 small"><strong>Version:</strong> 1.1.1</p>
                    <p class="mb-2 small"><strong>Language:</strong> Perl 5.x</p>
                    <p class="mb-0 small"><strong>Created:</strong> April 25, 1996</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Script Overview -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <strong>Script Overview</strong>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h3 class="h6">Key Features:</h3>
                            <ul class="small mb-0">
                                <li>Graphical display with customizable digit images</li>
                                <li>File locking for concurrent access</li>
                                <li>Referer validation for security</li>
                                <li>Access logging with timestamps</li>
                                <li>Configurable number of digits</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h3 class="h6">Included Subroutines:</h3>
                            <ul class="small mb-0">
                                <li><code>read_count()</code> - Read current count from file</li>
                                <li><code>write_count()</code> - Write count with file locking</li>
                                <li><code>log_access()</code> - Log visitor information</li>
                                <li><code>output_counter()</code> - Display counter image</li>
                                <li><code>output_error_image()</code> - Handle errors</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Source Code -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                    <strong>Perl Source Code</strong>
                    <span class="badge bg-success">Syntax Highlighted</span>
                </div>
                <div class="card-body p-0">
                    <pre class="bg-dark text-light p-3 rounded-0 mb-0" style="max-height: 600px; overflow-y: auto;"><code class="language-perl"><?php echo htmlspecialchars(file_get_contents(__DIR__ . '/counter.pl')); ?></code></pre>
                </div>
            </div>
        </div>
    </div>

    <!-- Configuration Variables -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="card border-warning">
                <div class="card-header bg-warning">
                    <strong>Important Configuration Variables</strong>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Variable</th>
                                <th>Purpose</th>
                                <th>Default Value</th>
                            </tr>
                        </thead>
                        <tbody class="small">
                            <tr>
                                <td><code>$count_file</code></td>
                                <td>Path to store the count</td>
                                <td>./count.txt</td>
                            </tr>
                            <tr>
                                <td><code>$lock_file</code></td>
                                <td>Lock file for concurrency</td>
                                <td>./count.lock</td>
                            </tr>
                            <tr>
                                <td><code>$log_file</code></td>
                                <td>Access log file path</td>
                                <td>./access_log</td>
                            </tr>
                            <tr>
                                <td><code>$digits_dir</code></td>
                                <td>Directory with digit images</td>
                                <td>./digits/</td>
                            </tr>
                            <tr>
                                <td><code>@valid_referers</code></td>
                                <td>Allowed referring domains</td>
                                <td>(empty - allows all)</td>
                            </tr>
                            <tr>
                                <td><code>$num_digits</code></td>
                                <td>Number of digits to display</td>
                                <td>6</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-success">
                <div class="card-header bg-success text-white">
                    <strong>Installation Steps</strong>
                </div>
                <div class="card-body">
                    <ol class="small mb-0">
                        <li>Upload to cgi-bin directory</li>
                        <li>Set permissions: <code>chmod 755</code></li>
                        <li>Create data directory</li>
                        <li>Edit configuration section</li>
                        <li>Test the script</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Usage Example -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>HTML Usage Example</strong>
                </div>
                <div class="card-body">
                    <p class="small mb-2">Add this code to your HTML page where you want the counter to appear:</p>
                    <pre class="bg-light p-3 rounded border"><code class="language-html">&lt;!-- Simple counter usage --&gt;
&lt;img src="/cgi-bin/counter.pl" alt="Hit Counter"&gt;

&lt;!-- With styling --&gt;
&lt;div class="counter-container"&gt;
    &lt;p&gt;Visitor Count:&lt;/p&gt;
    &lt;img src="/cgi-bin/counter.pl" alt="Hit Counter" style="border: 2px solid #000;"&gt;
&lt;/div&gt;</code></pre>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Notes -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-danger" role="alert">
                <h4 class="alert-heading">Security Considerations</h4>
                <ul class="mb-0 small">
                    <li><strong>Referer Validation:</strong> Configure <code>@valid_referers</code> to prevent counter theft from unauthorized sites</li>
                    <li><strong>File Permissions:</strong> Ensure data files are not in web-accessible directories</li>
                    <li><strong>Data Protection:</strong> Consider using .htaccess to protect the data directory</li>
                    <li><strong>Modern Alternative:</strong> For production websites, use modern analytics solutions for better security and features</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <a href="README" class="btn btn-info me-2">
                <i class="bi bi-book"></i> View README Documentation
            </a>
            <a href="/scripts/downloads/counter/" class="btn btn-secondary me-2">
                <i class="bi bi-arrow-left"></i> Back to Downloads
            </a>
            <a href="/scripts/counter.shtml" class="btn btn-outline-primary">
                <i class="bi bi-info-circle"></i> Counter Script Info
            </a>
        </div>
    </div>

    <!-- Code Structure -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>Code Structure</strong>
                </div>
                <div class="card-body">
                    <h3 class="h6">Script Components:</h3>
                    <ul class="small mb-0">
                        <li><strong>Configuration Section</strong> - User-editable settings</li>
                        <li><strong>Main Script</strong> - Core logic and flow control</li>
                        <li><strong>Subroutines</strong> - Modular functions</li>
                        <li><strong>POD Documentation</strong> - Embedded Perl documentation</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>Technical Details</strong>
                </div>
                <div class="card-body">
                    <h3 class="h6">Script Characteristics:</h3>
                    <ul class="small mb-0">
                        <li><strong>Lines of Code:</strong> ~200 (including comments)</li>
                        <li><strong>Dependencies:</strong> CGI.pm module</li>
                        <li><strong>File Operations:</strong> Read, write, lock</li>
                        <li><strong>Output:</strong> Dynamic HTML/GIF image</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Historical Context -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h3 class="h5 card-title">Historical Context</h3>
                    <p class="card-text small mb-2">The Counter script represented a significant advancement in web development during the mid-1990s. Before JavaScript and modern analytics, CGI scripts like this were the primary way to add dynamic functionality to static HTML pages. The graphical counter became an iconic element of early web design.</p>
                    <p class="card-text small mb-2"><strong>Technical Innovation:</strong> This script introduced several important concepts including file locking for concurrent access, security through referer validation, and the use of dynamically generated images - all groundbreaking features for the time.</p>
                    <p class="card-text small mb-0"><strong>Legacy:</strong> While modern websites use sophisticated analytics platforms, the Counter script remains an excellent example of clean, well-documented Perl CGI programming and serves as an educational resource for understanding early web technologies.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern Alternatives -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-info" role="alert">
                <h4 class="alert-heading">Modern Alternatives</h4>
                <p class="mb-2">For production websites, consider these modern analytics solutions:</p>
                <div class="row small">
                    <div class="col-md-6">
                        <ul class="mb-0">
                            <li><strong>Google Analytics</strong> - Comprehensive free analytics with detailed insights</li>
                            <li><strong>Plausible Analytics</strong> - Privacy-focused, lightweight analytics</li>
                            <li><strong>Matomo</strong> - Self-hosted, open-source analytics platform</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="mb-0">
                            <li><strong>Simple Analytics</strong> - Privacy-first analytics without cookies</li>
                            <li><strong>GoatCounter</strong> - Simple, privacy-friendly web analytics</li>
                            <li><strong>Fathom Analytics</strong> - GDPR-compliant website analytics</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Prism.js for Syntax Highlighting -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism-tomorrow.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/prism.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-perl.min.js"></script>
