<div class="container my-4">
    <!-- Breadcrumbs -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/">Home</a></li>
            <li class="breadcrumb-item"><a href="/scripts/">Scripts</a></li>
            <li class="breadcrumb-item"><a href="/scripts/counter.shtml">Counter</a></li>
            <li class="breadcrumb-item"><a href="/scripts/downloads/counter/">Downloads</a></li>
            <li class="breadcrumb-item active" aria-current="page">README</li>
        </ol>
    </nav>

    <!-- File Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <h1 class="display-5 mb-3">README - Counter Script Documentation</h1>
            <p class="lead">Complete documentation for Counter v1.1.1 - Graphical Hit Counter for Web Pages</p>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <strong>File Information</strong>
                </div>
                <div class="card-body">
                    <p class="mb-2 small"><strong>Filename:</strong> README</p>
                    <p class="mb-2 small"><strong>Type:</strong> Documentation</p>
                    <p class="mb-2 small"><strong>Script:</strong> Counter v1.1.1</p>
                    <p class="mb-0 small"><strong>Format:</strong> Plain Text</p>
                </div>
            </div>
        </div>
    </div>

    <!-- File Content -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>README File Contents</strong>
                </div>
                <div class="card-body p-0">
                    <pre class="bg-light p-3 rounded mb-0" style="max-height: 600px; overflow-y: auto;"><code><?php echo htmlspecialchars(file_get_contents(__DIR__ . '/README')); ?></code></pre>
                </div>
            </div>
        </div>
    </div>

    <!-- Documentation Sections Quick Links -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <strong>Quick Navigation</strong>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h3 class="h6">Key Sections:</h3>
                            <ul class="small">
                                <li><strong>Description</strong> - What the script does</li>
                                <li><strong>Features</strong> - Script capabilities</li>
                                <li><strong>Requirements</strong> - What you need</li>
                                <li><strong>Installation</strong> - Setup instructions</li>
                                <li><strong>Configuration</strong> - Customization options</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h3 class="h6">Additional Information:</h3>
                            <ul class="small">
                                <li><strong>Troubleshooting</strong> - Common problems</li>
                                <li><strong>Security Notes</strong> - Important warnings</li>
                                <li><strong>Modern Alternatives</strong> - Updated solutions</li>
                                <li><strong>License</strong> - Usage terms</li>
                                <li><strong>Support</strong> - Getting help</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Installation Overview -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="card border-success">
                <div class="card-header bg-success text-white">
                    <strong>Quick Installation Guide</strong>
                </div>
                <div class="card-body">
                    <ol class="mb-0 small">
                        <li>Upload counter.pl to your cgi-bin directory</li>
                        <li>Set file permissions: <code>chmod 755 counter.pl</code></li>
                        <li>Create a data directory with write permissions</li>
                        <li>Edit configuration variables in counter.pl</li>
                        <li>Add to HTML: <code>&lt;img src="/cgi-bin/counter.pl" alt="Hit Counter"&gt;</code></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-warning">
                <div class="card-header bg-warning">
                    <strong>Requirements</strong>
                </div>
                <div class="card-body">
                    <ul class="mb-0 small">
                        <li>Unix/Linux server</li>
                        <li>Perl 5.x or higher</li>
                        <li>CGI.pm module</li>
                        <li>Write permissions</li>
                        <li>FLY library (optional)</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <a href="counter.pl" class="btn btn-primary me-2">
                <i class="bi bi-file-code"></i> View counter.pl Script
            </a>
            <a href="/scripts/downloads/counter/" class="btn btn-secondary me-2">
                <i class="bi bi-arrow-left"></i> Back to Downloads
            </a>
            <a href="/scripts/counter.shtml" class="btn btn-outline-primary">
                <i class="bi bi-info-circle"></i> Counter Script Info
            </a>
        </div>
    </div>

    <!-- Historical Context -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h3 class="h5 card-title">Historical Context</h3>
                    <p class="card-text small mb-2">The Counter script was one of the most popular CGI scripts in the 1990s, providing webmasters with a simple way to track page visits. Before modern analytics like Google Analytics, hit counters were the primary method for measuring website traffic.</p>
                    <p class="card-text small mb-0"><strong>Created:</strong> April 25, 1996 | <strong>Version:</strong> 1.1.1 | <strong>Author:</strong> Matt's Script Archive</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern Alternatives Notice -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="alert alert-info" role="alert">
                <h4 class="alert-heading">Looking for Modern Solutions?</h4>
                <p class="mb-2">While this script is maintained for historical and educational purposes, modern websites should consider current analytics solutions:</p>
                <ul class="mb-0 small">
                    <li><strong>Google Analytics</strong> - Comprehensive free analytics platform</li>
                    <li><strong>Plausible Analytics</strong> - Privacy-focused lightweight analytics</li>
                    <li><strong>Matomo</strong> - Self-hosted analytics platform</li>
                    <li><strong>GoatCounter</strong> - Simple, privacy-friendly web analytics</li>
                </ul>
            </div>
        </div>
    </div>
</div>
